/*
 * Decompiled with CFR 0.152.
 */
package com.ggoralski.driftfx;

import com.ggoralski.driftfx.Drift;
import com.ggoralski.driftfx.TextsReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class FXMLDocumentController
implements Initializable {
    @FXML
    private Label label;
    @FXML
    private LineChart plot;
    @FXML
    private NumberAxis xAxis;
    @FXML
    private NumberAxis yAxis;
    @FXML
    private BorderPane borderPane;
    @FXML
    private WebView qWebView;
    @FXML
    private WebView genesNWebView;
    @FXML
    private WebView popNWebView;
    @FXML
    private WebView generationsWebView;
    @FXML
    private TextField qTextField;
    @FXML
    private TextField genesNTextField;
    @FXML
    private TextField popNTextField;
    @FXML
    private TextField generationsTextField;

    @FXML
    private void handleRunButtonAction(ActionEvent event) {
        this.run();
    }

    @FXML
    private void handleZakonczButtonAction(ActionEvent event) {
        Platform.exit();
    }

    public void run() {
        this.plot.getData().removeAll((Collection)this.plot.getData());
        double q = Double.parseDouble(this.qTextField.getText());
        int genesN = Integer.parseInt(this.genesNTextField.getText());
        int popN = Integer.parseInt(this.popNTextField.getText());
        int generations = Integer.parseInt(this.generationsTextField.getText());
        double[] qs = new double[genesN];
        Arrays.fill(qs, q);
        Drift drift = new Drift(qs, popN, generations);
        double[][] results = drift.run();
        int gen = 1;
        for (double[] vals : results) {
            XYChart.Series seria = this.toSeries(vals, String.valueOf(gen));
            this.plot.getData().add((Object)seria);
            seria.getNode().setStyle("-fx-stroke-width: 1;");
            ++gen;
        }
        this.xAxis.setUpperBound((double)generations);
        this.xAxis.setTickUnit((double)(generations / 10));
        this.xAxis.setAutoRanging(false);
    }

    private XYChart.Series toSeries(double[] tab, String name) {
        XYChart.Series series = new XYChart.Series();
        series.setName(name);
        for (int i = 0; i < tab.length; ++i) {
            series.getData().add((Object)new XYChart.Data((Object)i, (Object)tab[i]));
        }
        return series;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.qWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.genesNWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.popNWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.generationsWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        TextsReader tr = new TextsReader();
        HashMap<String, String> texts = tr.getTexts("PL");
        this.label.setText("DriftFX - " + texts.get("shortDesc"));
        WebEngine webEngine = this.qWebView.getEngine();
        webEngine.loadContent(texts.get("freqAll"));
        webEngine = this.genesNWebView.getEngine();
        webEngine.loadContent(texts.get("lociNum"));
        webEngine = this.popNWebView.getEngine();
        webEngine.loadContent(texts.get("populationN"));
        webEngine = this.generationsWebView.getEngine();
        webEngine.loadContent(texts.get("generationMax"));
        this.xAxis.setLabel(texts.get("generations"));
        this.xAxis.setTickUnit(3.0);
        this.yAxis.setLabel(texts.get("frequency"));
    }
}

