/*
 * Decompiled with CFR 0.152.
 */
package com.ggoralski.driftfx;

import java.util.Arrays;

public class Drift {
    double[] qs;
    int population;
    int nrOfGenerations;

    public Drift(double[] qs, int population, int nrOfGenerations) {
        this.qs = qs;
        this.population = population;
        this.nrOfGenerations = nrOfGenerations;
    }

    public double[] runDriftOneAllele(double q) {
        double[] qVals = new double[]{q};
        int n2 = this.population * 2;
        for (int i = 1; i < this.nrOfGenerations && q > 0.0 && q < 1.0; ++i) {
            q = Drift.getBinomial(n2, q);
            qVals = Arrays.copyOf(qVals, qVals.length + 1);
            qVals[i] = q;
        }
        return qVals;
    }

    public static double getBinomial(int n, double p) {
        double x = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.random() < p)) continue;
            x += 1.0;
        }
        return x / (double)n;
    }

    public double[][] run() {
        int nrLoci = this.qs.length;
        double[][] results = new double[nrLoci][];
        for (int i = 0; i < nrLoci; ++i) {
            results[i] = this.runDriftOneAllele(this.qs[i]);
        }
        return results;
    }
}

