/*
 * Decompiled with CFR 0.152.
 */
package doborfx;

import doborfx.Dobor;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class FXMLDocumentController
implements Initializable {
    @FXML
    private Label label;
    @FXML
    private LineChart plot;
    @FXML
    private WebView qWebView;
    @FXML
    private WebView wAAWebView;
    @FXML
    private WebView wAaWebView;
    @FXML
    private WebView waaWebView;
    @FXML
    private WebView generationsWebView;
    @FXML
    private WebView qSeeWebView;
    @FXML
    private WebView wsSeeWebView;
    @FXML
    private WebView dqSeeWebView;
    @FXML
    private WebView pAASeeWebView;
    @FXML
    private WebView pAaSeeWebView;
    @FXML
    private WebView paaSeeWebView;
    @FXML
    private TextField qTextField;
    @FXML
    private TextField wAATextField;
    @FXML
    private TextField wAaTextField;
    @FXML
    private TextField waaTextField;
    @FXML
    private TextField generationsTextField;
    @FXML
    private RadioButton qSeeRadioButton;
    @FXML
    private RadioButton wsSeeRadioButton;
    @FXML
    private RadioButton dqSeeRadioButton;
    @FXML
    private RadioButton pAASeeRadioButton;
    @FXML
    private RadioButton pAaSeeRadioButton;
    @FXML
    private RadioButton paaSeeRadioButton;

    @FXML
    private void handleRunButtonAction(ActionEvent event) {
        this.run();
    }

    @FXML
    private void handleZakonczButtonAction(ActionEvent event) {
        Platform.exit();
    }

    public void run() {
        boolean ifQSee = this.qSeeRadioButton.isSelected();
        boolean ifWsSee = this.wsSeeRadioButton.isSelected();
        boolean ifDqSee = this.dqSeeRadioButton.isSelected();
        this.plot.getData().removeAll((Collection)this.plot.getData());
        double q = Double.parseDouble(this.qTextField.getText());
        double wAA = Double.parseDouble(this.wAATextField.getText());
        double wAa = Double.parseDouble(this.wAaTextField.getText());
        double waa = Double.parseDouble(this.waaTextField.getText());
        int generations = Integer.parseInt(this.generationsTextField.getText());
        Dobor dobor = new Dobor(q, wAA, wAa, waa, generations);
        dobor.run();
        if (ifQSee) {
            XYChart.Series qsSer = this.toSeries(dobor.getqVals(), "Frekwencja allelu a (q)");
            this.plot.getData().add((Object)qsSer);
            qsSer.getNode().setStyle("-fx-stroke: #ffaa00;");
        }
        if (ifWsSee) {
            XYChart.Series wssSer = this.toSeries(dobor.getWsVals(), "\u015arednie dostosowanie populacji (Ws)");
            this.plot.getData().add((Object)wssSer);
            wssSer.getNode().setStyle("-fx-stroke: #00dddd;");
        }
        if (ifDqSee) {
            XYChart.Series dqsSer = this.toSeries(dobor.getdQVals(), "Zmiana frekwencji allelu a (dq)");
            this.plot.getData().add((Object)dqsSer);
            dqsSer.getNode().setStyle("-fx-stroke: #aa00ff;");
        }
        if (this.pAASeeRadioButton.isSelected()) {
            XYChart.Series pAASer = this.toSeries(dobor.getPAAVals(), "Frekwencja genotypu AA (PAA)");
            this.plot.getData().add((Object)pAASer);
            pAASer.getNode().setStyle("-fx-stroke-dash-array: 5 10; -fx-stroke-line-cap: round; -fx-stroke: #880000;");
        }
        if (this.pAaSeeRadioButton.isSelected()) {
            XYChart.Series pAaSer = this.toSeries(dobor.getPAaVals(), "Frekwencja genotypu Aa (PAa)");
            this.plot.getData().add((Object)pAaSer);
            pAaSer.getNode().setStyle("-fx-stroke-dash-array: 5 10; -fx-stroke-line-cap: round; -fx-stroke: #008800;");
        }
        if (this.paaSeeRadioButton.isSelected()) {
            XYChart.Series paaSer = this.toSeries(dobor.getPaaVals(), "Frekwencja genotypu aa (Paa)");
            this.plot.getData().add((Object)paaSer);
            paaSer.getNode().setStyle("-fx-stroke-dash-array: 5 10; -fx-stroke-line-cap: round; -fx-stroke: #000088; ");
        }
    }

    private XYChart.Series toSeries(double[] tab, String name) {
        XYChart.Series series = new XYChart.Series();
        series.setName(name);
        for (int i = 0; i < tab.length; ++i) {
            series.getData().add((Object)new XYChart.Data((Object)i, (Object)tab[i]));
        }
        return series;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.qWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.wAAWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.wAaWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.waaWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.generationsWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.qSeeWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.wsSeeWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.dqSeeWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.pAASeeWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.pAaSeeWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        this.paaSeeWebView.getEngine().setUserStyleSheetLocation(this.getClass().getResource("mojestyle.css").toExternalForm());
        WebEngine webEngine = this.qWebView.getEngine();
        webEngine.loadContent("<p>Frekwencja allelu <i>a</i>(<i>q</i>)</p>");
        webEngine = this.wAAWebView.getEngine();
        webEngine.loadContent("<p>Dostosowanie genotypu <i>AA</i><br>(<i>W<sub>AA</sub></i>)</p>");
        webEngine = this.wAaWebView.getEngine();
        webEngine.loadContent("<p>Dostosowanie genotypu <i>Aa</i><br>(<i>W<sub>Aa</sub></i>)</p>");
        webEngine = this.waaWebView.getEngine();
        webEngine.loadContent("<p>Dostosowanie genotypu <i>aa</i><br>(<i>W<sub>aa</sub></i>)</p>");
        webEngine = this.generationsWebView.getEngine();
        webEngine.loadContent("<p>pokole\u0144</p>");
        webEngine = this.qSeeWebView.getEngine();
        webEngine.loadContent("<p>Frekwencja allelu <i>a</i> (<i>q</i>)</p>");
        webEngine = this.wsSeeWebView.getEngine();
        webEngine.loadContent("<p>\u015arednie dostosowanie<br/> w populacji (<i>Ws</i>)</p>");
        webEngine = this.dqSeeWebView.getEngine();
        webEngine.loadContent("<p>Zmiana frekwencji<br/> allelu <i>a</i> (<i>dq</i>)</p>");
        webEngine = this.pAASeeWebView.getEngine();
        webEngine.loadContent("<p>Frekwencja genotypu <i>AA</i><br>(<i>P<sub>AA</sub></i>)</p>");
        webEngine = this.pAaSeeWebView.getEngine();
        webEngine.loadContent("<p>Frekwencja genotypu <i>Aa</i><br>(<i>P<sub>Aa</sub></i>)</p>");
        webEngine = this.paaSeeWebView.getEngine();
        webEngine.loadContent("<p>Frekwencja genotypu <i>aa</i><br>(<i>P<sub>aa</sub></i>)</p>");
    }
}

