/*
 * Decompiled with CFR 0.152.
 */
package doborfx;

public class Dobor {
    private double startQ;
    private double q;
    private double p;
    private double wAA;
    private double wAa;
    private double waa;
    private double[] qVals;
    private double[] dQVals;
    private double[] wsVals;
    private double ws;
    private int maxGenerations;
    private double[] PAAVals;
    private double[] PAaVals;
    private double[] PaaVals;

    public Dobor(double startQ, double wAA, double wAa, double waa, int maxGenerations) {
        this.startQ = startQ;
        this.wAA = wAA;
        this.wAa = wAa;
        this.waa = waa;
        this.maxGenerations = maxGenerations;
        this.q = startQ;
        this.p = 1.0 - this.q;
        this.wsVals = new double[maxGenerations + 1];
        this.qVals = new double[maxGenerations + 1];
        this.dQVals = new double[maxGenerations + 1];
        this.PAAVals = new double[maxGenerations + 1];
        this.PAaVals = new double[maxGenerations + 1];
        this.PaaVals = new double[maxGenerations + 1];
        this.wsVals[0] = this.ws = this.p * this.p * wAA + 2.0 * this.p * this.q * wAa + this.q * this.q * waa;
        this.qVals[0] = this.q;
        this.dQVals[0] = 0.0;
        this.PAAVals[0] = this.p * this.p;
        this.PAaVals[0] = 2.0 * this.p * this.q;
        this.PaaVals[0] = this.q * this.q;
    }

    public void run() {
        for (int i = 1; i <= this.getMaxGenerations(); ++i) {
            double dq = this.p * this.q / this.ws * (this.q * (this.waa - this.wAa) - this.p * (this.wAA - this.wAa));
            this.q += dq;
            this.p = 1.0 - this.q;
            this.wsVals[i] = this.ws = this.p * this.p * this.wAA + 2.0 * this.p * this.q * this.wAa + this.q * this.q * this.waa;
            this.qVals[i] = this.q;
            this.dQVals[i] = dq;
            this.PAAVals[i] = this.p * this.p;
            this.PAaVals[i] = 2.0 * this.p * this.q;
            this.PaaVals[i] = this.q * this.q;
        }
    }

    public double getQ() {
        return this.q;
    }

    public void setQ(double q) {
        this.q = q;
    }

    public double getwAA() {
        return this.wAA;
    }

    public void setwAA(double wAA) {
        this.wAA = wAA;
    }

    public double getwAa() {
        return this.wAa;
    }

    public void setwAa(double wAa) {
        this.wAa = wAa;
    }

    public double getWaa() {
        return this.waa;
    }

    public void setWaa(double waa) {
        this.waa = waa;
    }

    public double[] getqVals() {
        return this.qVals;
    }

    public double[] getdQVals() {
        return this.dQVals;
    }

    public double[] getWsVals() {
        return this.wsVals;
    }

    public double getStartQ() {
        return this.startQ;
    }

    public void setStartQ(double startQ) {
        this.startQ = startQ;
    }

    public double getWs() {
        return this.ws;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p;
    }

    public int getMaxGenerations() {
        return this.maxGenerations;
    }

    public void setMaxGenerations(int maxGenerations) {
        this.maxGenerations = maxGenerations;
    }

    public double[] getPAAVals() {
        return this.PAAVals;
    }

    public double[] getPAaVals() {
        return this.PAaVals;
    }

    public double[] getPaaVals() {
        return this.PaaVals;
    }
}

